/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.rewrite;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.utils.Util;

public class NecroticModifierRewrite
extends Modifier
implements ProjectileHitModifierHook,
MeleeHitModifierHook,
TooltipModifierHook {
    private static final Component LIFE_STEAL_CRITICAL = TConstruct.makeTranslation((String)"modifier", (String)"necroticrewrite.lifesteal_critical");
    private static final Component LIFE_STEAL = TConstruct.makeTranslation((String)"modifier", (String)"necroticrewrite.lifesteal");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT, ModifierHooks.TOOLTIP);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (damageDealt > 0.0f) {
            int level = modifier.getLevel();
            float percent = context.isFullyCharged() && context.isCritical() ? 0.12f * (float)level : 0.08f * (float)level;
            if (percent > 0.0f) {
                LivingEntity attacker = context.getAttacker();
                if (damageDealt <= 50.0f) {
                    attacker.m_5634_(percent * damageDealt);
                } else {
                    attacker.m_5634_(20.0f);
                }
                attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), Sounds.NECROTIC_HEAL.getSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        float percent;
        if (target != null && attacker != null && projectile instanceof AbstractArrow && (percent = (arrow = (AbstractArrow)projectile).m_36792_() ? 0.12f * (float)modifier.getLevel() : 0.08f * (float)modifier.getLevel()) > 0.0f) {
            float damageDealt = (float)Math.min((double)target.m_21223_(), arrow.m_36789_() * arrow.m_20184_().m_82553_());
            if (damageDealt <= 30.0f) {
                attacker.m_5634_(percent * damageDealt);
            } else {
                attacker.m_5634_(12.0f);
            }
            attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), Sounds.NECROTIC_HEAL.getSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return false;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        int level = modifier.getLevel();
        if (level > 0) {
            tooltip.add((Component)this.applyStyle(Component.m_237115_((String)(Util.PERCENT_FORMAT.format((float)level * 0.12f) + " ")).m_7220_(LIFE_STEAL_CRITICAL)));
            tooltip.add((Component)this.applyStyle(Component.m_237115_((String)(Util.PERCENT_FORMAT.format((float)level * 0.08f) + " ")).m_7220_(LIFE_STEAL)));
        }
    }
}

